#
# https://qiita.com/take_me/items/1ae60fda590a2385d196 のコードを流用させていただきました
#
Param( [string] $input_filename , [string] $output_filename, [int] $freq)
#
function Select-ffmpegLog([parameter(mandatory=$true)][string]$File, [string]$Pattern = "max_volume:") {
    # ffmpegは標準エラーに出力されてしまうので、標準出力に渡しなおす
    ffmpeg -i $File -vn -af volumedetect -f null - 2>&1 | Select-String $Pattern;
}

function Find-MaxVolume([parameter(mandatory=$true)][string]$File) {
    <#
        .SYNOPSIS
            対象ファイルのmax_volumeを'10 dB'の形式で取得して返す
    #>
    $pattern = "max_volume:";
    $raw = Select-ffmpegLog $File $pattern;
    $raw.Tostring().Substring($raw.Matches.Index + $pattern.Length);
}

function Remove-dB([parameter(mandatory=$true)][string]$dBString) {
    <#
        .SYNOPSIS
            '10 dB' -> '10'のように取り出す
    #>
    $dBString = $dBString.Replace(' ', '');
    $dBString -replace "(\d+)dB", "`$1";
}

function Get-VolumeGain([parameter(mandatory=$true)][string]$File, [float]$TargetVolume = 0.0) {
    $max_volume = [float](Remove-dB (Find-MaxVolume $File));
    $gain = [Math]::Truncate($TargetVolume - $max_volume * 10) / 10;     # 小数点第1位で切り捨て
    "${gain}dB";
}

function Set-MaxVolume([parameter(mandatory=$true)][string]$InputFile, [parameter(mandatory=$true)][string]$OutputFile, [float]$TargetVolume = 0.0) {
    $gain = Get-VolumeGain $InputFile $TargetVolume;
#    ffmpeg -i $InputFile -af volume=$gain $OutputFile;
    ffmpeg -i $InputFile -vn -ac 1 -ar $freq -acodec pcm_u8 -af volume=$gain $OutputFile;
}
#Set-MaxVolume -InputFile Bass_o1B.wav -OutputFile BA_o1B.wav -TargetVolume -20.0
#write-host $freq
Set-MaxVolume -InputFile $input_filename -OutputFile $output_filename -TargetVolume -20.0
