;---------------------------------
; EMM の動画データを再生
;
; Ver.0.01 2022-09-17 by kanegonMZ
; ・初版
; Ver.0.08 2024-06-16 by kanegonMZ
; ・EMMのI/Oにウェイトがあることを想定し、1ラスタで8バイト転送に変更。
; Ver0.09 2024-10-05 by kanegonMZ
; ・PAL版MZ-700に対応。MZ700PAL=1でPAL版をビルド
;
; I/OデータのPIO-3034 320K EMM は I/Oアドレス 00～03 で 320KB。DIP SW でベースアドレスは変更可能らしい。
; Unicard mk3b はramdisk.cfg で 最大16MBまで。
; Unicard mk3b はemm.cfg で PIO-3034 と互換。640KB固定？
; EmuZ-700/800/1500は最大16MBまで、I/Oアドレス 00～03 。
; 16MB = $100000
;
;
;	アドレス系定数
;
VRAM	EQU		$D000
;
;	I/Oアドレス定数
;
EMM_AD		EQU	$00		; PIO-3034
EMM_DATA	EQU	$03		; PIO-3034

;
; メモリマップドI/O のアドレス
;
IO8255_PortA	EQU	$E000
IO8255_PortB	EQU	$E001
IO8255_PortC	EQU	$E002
IO8255_CTRL		EQU	$E003
IO8253_CH0		EQU	$E004
IO8253_CH1		EQU	$E005
IO8253_CH2		EQU	$E006
IO8253_CTRL		EQU	$E007
IO8253_STATUS	EQU	$E008
;
; バンク切り替えのポート
;
BANK_00_DRAM	EQU	$E0
BANK_D0_DRAM	EQU	$E1
BANK_00_MONI	EQU	$E2
BANK_D0_VRAM	EQU	$E3
BANK_MONVRAM	EQU	$E4
BANK_D0_PCG		EQU	$E5
BANK_PCG_CLOSE	EQU	$E6
;
; ダミーアクセス用アドレス
;
DUMMY_READ		EQU	$1200
;
; NTSC/PAL 1フレームのラスタ数
;
IF MZ700PAL
	LINES_PER_FRAME		EQU	312			; PAL
	LINES_PER_SCREEN	EQU	250			; 1画面(=2000 bytes)書くのに必要な LINE(1 LINE = 8 Byte)
ELSE
	LINES_PER_FRAME		EQU	262			; NTSC
	LINES_PER_SCREEN	EQU	250			; 1画面(=2000 bytes)書くのに必要な LINE(1 LINE = 8 Byte)
ENDIF
;
; マクロ
;
; EMM から読みだしてVRAMに書き込む( Thanks @youkan700 )
;
									;表示期間:ブランク期間 消費クロック(NTSC)
									;     165:63
									;表示期間:ブランク期間 消費クロック(PAL)
									;     146:82
; 以下、IN で 1 wait 入ると想定。2,3 wait でも大丈夫そうだが、4 wait ではNG LD C,EMM_DATA をループ外に追い出せばいけるかも？
EMMREAD_AND_VRAMWRITE	MACRO
	IN		H,(C)						; 13( 13)		データ読み取り[0]
	IN		L,(C)						; 13( 26)		データ読み取り[1]
	IN		D,(C)						; 13( 39)		データ読み取り[2]
	IN		E,(C)						; 13( 52)		データ読み取り[3]
	EXX									;  4( 56)		(裏)
	IN		H,(C)						; 13( 69)		データ読み取り[4]
	IN		L,(C)						; 13( 82)		データ読み取り[5]
	IN		D,(C)						; 13( 95)		データ読み取り[6]
	IN		E,(C)						; 13(108)		データ読み取り[7]
	IN		A,(EMM_DATA)				; 12(120)		データ読み取り[8](SOUND)
	LD		SP, VRAM + ( 8 * %1 ) + 8	; 10(130)		VRAM転送先(展開済みにしてあらかじめアドレス計算しておく)
;
	PUSH	DE							;  5(135) : 6(171)	データ書き込み[7,6]	165 - 135 = 30 clk
	PUSH	HL							;		  :11(182)	データ書き込み[5,4]
	EXX									;		  : 4(186)	(表)
	PUSH	DE							;		  :11(197)	データ書き込み[3,2]
	PUSH	HL							;		  :11(208)	データ書き込み[1,0]
	LD		( IO8253_CH0 ),A			;		  :13(221)	データ書き込み[8](SOUND)

	IN		H,(C)						;  6(  6) : 7(228)	データ読み取り[0]
	IN		L,(C)						; 13( 19)			データ読み取り[1]
	IN		D,(C)						; 13( 32)			データ読み取り[2]
	IN		E,(C)						; 13( 45)			データ読み取り[3]
	EXX									;  4( 49)			(裏)
	IN		H,(C)						; 13( 62)			データ読み取り[4]
	IN		L,(C)						; 13( 75)			データ読み取り[5]
	IN		D,(C)						; 13( 88)			データ読み取り[6]
	IN		E,(C)						; 13(101)			データ読み取り[7]
	IN		A,(EMM_DATA)				; 12(113)			データ読み取り[8](SOUND)
	LD		SP, VRAM + ( 8 * %1 ) + 8 + $0800; 10(123)		VRAM転送先(展開済みにしてあらかじめアドレス計算しておく
;
	PUSH	DE							;  5(128) : 6(171)	データ書き込み[7,6]   165-128 = 37 wait
	PUSH	HL							;		  :11(182)	データ書き込み[5,4]
	EXX									;		  : 4(186)	(表)
	PUSH	DE							;		  :11(197)	データ書き込み[3,2]
	PUSH	HL							;		  :11(208)	データ書き込み[1,0]
	LD		( IO8253_CH0 ),A			;		  :13(221)	データ書き込み[8](SOUND)
										;		  :-7		7 clk 余裕	次で7clk先行することになるが、V-RAMアクセス時に待たされるので問題ない。
ENDM
;
; プログラム開始
;
	ORG		$1200
;
	DI
	OUT		( BANK_D0_VRAM ),A			; $D000- を V-RAM、メモリマップド I/O に。
 	LD		( EXIT + 1 ),SP				; モニタに戻る時のために SP 保存
;
; MZ-1500向け初期化
;
	LD		A,0000_0001B				; 8253 Ch.2からの割り込みマスク、8253 Ch.0のサウンドをマスクしない
	LD		( IO8255_PortC ),A
	OUT		( BANK_PCG_CLOSE ),A		; MZ-1500: PCGバンクを閉じる
;
;	8253 の初期化
;
	LD		A,1
	LD		(IO8253_STATUS),A		; 8253 Ch.0のGATE入力へ(これやらないと音がでない…)
	LD		A,00_01_000_0B	; チャネル0 でカウンタの下位バイトアクセス、Mode 0、カウントモード 16ビットバイナリ
	LD		(IO8253_CTRL),A
;							; モードセットでカウンタリセットされるので明示的な 0 セットは不要
							; 以降、IO8253_CH0 に書くだけで下位バイト更新となる。
MUGEN_LOOP:
;
;	EMM の初期化
;	読み込み先頭アドレスを 000000h にする。最初に指定してあとはオートインクリメントに任せる
; EMM DATA
;  +00   : fps ( 60/30/20/15/12/10/6/5/4/3/2/1/0) 0は最初に 1枚だけ表示して後は音だけ
;  +01   : Version
;	7:Reserved      0
;	6:Reserved      0
;	5:Reserved      0
;	4:Reserved      0
;	3:Reserved      0
;	2:Reserved      0
;	1:Version(0)    1:008 以降
;	0: NTSC/PAL     0:NTSC  1:PAL
;  +02,03 : ループ回数  ただし、fps=0 の時は画面描画しないフレーム数
;
	LD		BC,EMM_AD			; B は 0 でいいので
	OUT		(C),B				; アドレスカウンタのBit7-0は 0 でいい。
	INC		C
	OUT		(C),B				; アドレスカウンタ Bit15-8
	INC		C
	OUT		(C),B				; アドレスカウンタ Bit23-16
;
	IN		A,(EMM_DATA)		; fps 読み込み
	CP		18					; 最大 18までなので。(NTSC/PALでチェックはしたいが)
	JR		Z,FPS_0				; FPS=0 だけちょっと例外
	JP		NC,EXIT				; ここまで fps の値チェック。想定外なら即終了
	LD		L,A
	LD		H,0
	ADD		HL,HL				; TABLEの値が2バイトごとなので2倍
	LD		DE,SOUND_ONLY_LINE_TABLE
	ADD		HL,DE
	LD		A,(HL)
	LD		( SOUND_ONLY_LINE + 1 ) ,A	; FPS に応じた音声のみライン数を書く
	INC		HL
	LD		A,(HL)
	LD		( SOUND_ONLY_LINE + 2 ) ,A	; FPS に応じた音声のみライン数を書く
	IN		A,(EMM_DATA)				; Version等読み込み(未対応)
										; 本当はバージョンチェック、NTSC/PALチェックしたい
	IN		A,(EMM_DATA)				; 画像表示ループ回数下位バイト読み込み
	LD		IXL,A
	IN		A,(EMM_DATA)
	LD		IXH,A						; 画像表示ループ回数上位バイト読み込み
	JR		@f
FPS_0:
	IN		A,(EMM_DATA)				; Version等読み込み(未対応)
	IN		A,(EMM_DATA)				; 画像表示ループ回数下位バイト読み込み
	LD		( SOUND_ONLY_LINE + 1 ) ,A	; FPS=0 の場合は表示回数のところがサウンド回数に(美しくない)
	IN		A,(EMM_DATA)
	LD		( SOUND_ONLY_LINE + 2 ) ,A	; FPS=0 の場合は表示回数のところがサウンド回数に(美しくない)
	LD		IX,1					; 画面表示ループ回数としては 1回なので
;
@@:
	LD		C,EMM_DATA			; 表の C にセットしとく。破壊するな。
	EXX							; (裏)
	LD		C,EMM_DATA			; 裏の C もセットしとく。破壊するな。
	EXX							; (表)

;
; V_BLANK の立下りまで待つ
;
	XOR		A
	LD		HL,IO8255_PortC
V_BLANK_1:
	OR		(HL)				;  7
	JP		P,V_BLANK_1			; 10 V_BLANK=1(Not BLANK)まで待つ
V_BLANK_0:
	AND		(HL)				; 7
	JP		M,V_BLANK_0			; 10 / V_BLANK=0(BLANK)まで待つ。
;
; VRAMにダミーのアクセスを行い、同期を取る
;  JP M, の分足りないのと、ループのクロック(17)が 228 の約数ではないのでぴったり合わない
;  ことが多いので、一回 V-RAM アクセスで同期して、あとはクロック数で帳尻あわせる。
;
	LD		IY,( DUMMY_READ )	; 20	V_BLANK 検出時は H_BLANK 期間中でもあるので
	LD		IY,( DUMMY_READ )	; 20	H_BLANK 期間(63 clk)以上のダミーウェイトを
	LD		IY,( DUMMY_READ )	; 20	入れる。
	LD		IY,( DUMMY_READ )	; 20
	LD		A,(VRAM)			; 13( 10):  3( 3)	ダミーアクセスで同期を取る
								; 残り 60 + 261 * 228 = 59,568 / LINES_PER_FRAME -1	(NTSC)

	LD		HL, 2481			;     16(残り 59,552)
@@:								; 59,544(残り      8)  ( 6 + 4 + 4 + 10 ) * 2481
	DEC		HL					;		    6
	LD		A,H					;		    4
	OR		L					;		    4
	JP		NZ,@b				;		   10

	NOP							;  4(残り 4)
	NOP							;  4(残り 0)
;
MAIN_LOOP:
	EMMREAD_AND_VRAMWRITE	0
	EMMREAD_AND_VRAMWRITE	1
	EMMREAD_AND_VRAMWRITE	2
	EMMREAD_AND_VRAMWRITE	3
	EMMREAD_AND_VRAMWRITE	4
	EMMREAD_AND_VRAMWRITE	5
	EMMREAD_AND_VRAMWRITE	6
	EMMREAD_AND_VRAMWRITE	7
	EMMREAD_AND_VRAMWRITE	8
	EMMREAD_AND_VRAMWRITE	9
	EMMREAD_AND_VRAMWRITE	10
	EMMREAD_AND_VRAMWRITE	11
	EMMREAD_AND_VRAMWRITE	12
	EMMREAD_AND_VRAMWRITE	13
	EMMREAD_AND_VRAMWRITE	14
	EMMREAD_AND_VRAMWRITE	15
	EMMREAD_AND_VRAMWRITE	16
	EMMREAD_AND_VRAMWRITE	17
	EMMREAD_AND_VRAMWRITE	18
	EMMREAD_AND_VRAMWRITE	19
	EMMREAD_AND_VRAMWRITE	20
	EMMREAD_AND_VRAMWRITE	21
	EMMREAD_AND_VRAMWRITE	22
	EMMREAD_AND_VRAMWRITE	23
	EMMREAD_AND_VRAMWRITE	24
	EMMREAD_AND_VRAMWRITE	25
	EMMREAD_AND_VRAMWRITE	26
	EMMREAD_AND_VRAMWRITE	27
	EMMREAD_AND_VRAMWRITE	28
	EMMREAD_AND_VRAMWRITE	29
	EMMREAD_AND_VRAMWRITE	30
	EMMREAD_AND_VRAMWRITE	31
	EMMREAD_AND_VRAMWRITE	32
	EMMREAD_AND_VRAMWRITE	33
	EMMREAD_AND_VRAMWRITE	34
	EMMREAD_AND_VRAMWRITE	35
	EMMREAD_AND_VRAMWRITE	36
	EMMREAD_AND_VRAMWRITE	37
	EMMREAD_AND_VRAMWRITE	38
	EMMREAD_AND_VRAMWRITE	39
	EMMREAD_AND_VRAMWRITE	40
	EMMREAD_AND_VRAMWRITE	41
	EMMREAD_AND_VRAMWRITE	42
	EMMREAD_AND_VRAMWRITE	43
	EMMREAD_AND_VRAMWRITE	44
	EMMREAD_AND_VRAMWRITE	45
	EMMREAD_AND_VRAMWRITE	46
	EMMREAD_AND_VRAMWRITE	47
	EMMREAD_AND_VRAMWRITE	48
	EMMREAD_AND_VRAMWRITE	49
	EMMREAD_AND_VRAMWRITE	50
	EMMREAD_AND_VRAMWRITE	51
	EMMREAD_AND_VRAMWRITE	52
	EMMREAD_AND_VRAMWRITE	53
	EMMREAD_AND_VRAMWRITE	54
	EMMREAD_AND_VRAMWRITE	55
	EMMREAD_AND_VRAMWRITE	56
	EMMREAD_AND_VRAMWRITE	57
	EMMREAD_AND_VRAMWRITE	58
	EMMREAD_AND_VRAMWRITE	59
	EMMREAD_AND_VRAMWRITE	60
	EMMREAD_AND_VRAMWRITE	61
	EMMREAD_AND_VRAMWRITE	62
	EMMREAD_AND_VRAMWRITE	63
	EMMREAD_AND_VRAMWRITE	64
	EMMREAD_AND_VRAMWRITE	65
	EMMREAD_AND_VRAMWRITE	66
	EMMREAD_AND_VRAMWRITE	67
	EMMREAD_AND_VRAMWRITE	68
	EMMREAD_AND_VRAMWRITE	69
	EMMREAD_AND_VRAMWRITE	70
	EMMREAD_AND_VRAMWRITE	71
	EMMREAD_AND_VRAMWRITE	72
	EMMREAD_AND_VRAMWRITE	73
	EMMREAD_AND_VRAMWRITE	74
	EMMREAD_AND_VRAMWRITE	75
	EMMREAD_AND_VRAMWRITE	76
	EMMREAD_AND_VRAMWRITE	77
	EMMREAD_AND_VRAMWRITE	78
	EMMREAD_AND_VRAMWRITE	79
	EMMREAD_AND_VRAMWRITE	80
	EMMREAD_AND_VRAMWRITE	81
	EMMREAD_AND_VRAMWRITE	82
	EMMREAD_AND_VRAMWRITE	83
	EMMREAD_AND_VRAMWRITE	84
	EMMREAD_AND_VRAMWRITE	85
	EMMREAD_AND_VRAMWRITE	86
	EMMREAD_AND_VRAMWRITE	87
	EMMREAD_AND_VRAMWRITE	88
	EMMREAD_AND_VRAMWRITE	89
	EMMREAD_AND_VRAMWRITE	90
	EMMREAD_AND_VRAMWRITE	91
	EMMREAD_AND_VRAMWRITE	92
	EMMREAD_AND_VRAMWRITE	93
	EMMREAD_AND_VRAMWRITE	94
	EMMREAD_AND_VRAMWRITE	95
	EMMREAD_AND_VRAMWRITE	96
	EMMREAD_AND_VRAMWRITE	97
	EMMREAD_AND_VRAMWRITE	98
	EMMREAD_AND_VRAMWRITE	99
	EMMREAD_AND_VRAMWRITE	100
	EMMREAD_AND_VRAMWRITE	101
	EMMREAD_AND_VRAMWRITE	102
	EMMREAD_AND_VRAMWRITE	103
	EMMREAD_AND_VRAMWRITE	104
	EMMREAD_AND_VRAMWRITE	105
	EMMREAD_AND_VRAMWRITE	106
	EMMREAD_AND_VRAMWRITE	107
	EMMREAD_AND_VRAMWRITE	108
	EMMREAD_AND_VRAMWRITE	109
	EMMREAD_AND_VRAMWRITE	110
	EMMREAD_AND_VRAMWRITE	111
	EMMREAD_AND_VRAMWRITE	112
	EMMREAD_AND_VRAMWRITE	113
	EMMREAD_AND_VRAMWRITE	114
	EMMREAD_AND_VRAMWRITE	115
	EMMREAD_AND_VRAMWRITE	116
	EMMREAD_AND_VRAMWRITE	117
	EMMREAD_AND_VRAMWRITE	118
	EMMREAD_AND_VRAMWRITE	119
	EMMREAD_AND_VRAMWRITE	120
	EMMREAD_AND_VRAMWRITE	121
	EMMREAD_AND_VRAMWRITE	122
	EMMREAD_AND_VRAMWRITE	123
	EMMREAD_AND_VRAMWRITE	124
;
; LINES_PER_FRAME - LINES_PER_SCREEN = 12 ライン分はサウンドのみなので以下に専用コード。
; さらに FPS が 60未満は画面表示はしないでサウンドのみのフレームがあるので、その分もここで回す
; ただし、V-RAM書き込みアリの場合とまったく同じタイミングでサウンド書き込みしないとノイズの原因となる。
;		LD		( IO8253_CH0 ),A			;		  :13(221)	データ書き込み[8](SOUND)

									;表示期間:ブランク期間 消費クロック(NTSC)
									;     165:63
									;表示期間:ブランク期間 消費クロック(PAL)
									;     146:82
SOUND_ONLY_LINE:
										;  (- 7)	7クロック先行しているはずなので
	LD		HL,11						;10(  3)   fps に応じたループ数。最後のループは特別にするため1回少なく。
;
HIDDEN_FRAME_LOOP:
	IN		A,(EMM_DATA)				; 12( 15)			データ読み取り[8](SOUND)
	LD		SP, VRAM + 1010				; 10( 25)			VRAM転送先。ダミーなので画面外に。8バイト書き込むので +1008以上であればOK
;
	PUSH	DE							;  5( 30) : 6(171)	データ書き込み[7,6]	5クロック消費して H_BLANKまで待たされる
	PUSH	DE							;		  :11(182)	データ書き込み[5,4]
	NOP									;		  : 4(186)	ダミー
	PUSH	DE							;		  :11(197)	データ書き込み[3,2]
	PUSH	DE							;		  :11(208)	データ書き込み[1,0]
	LD		( IO8253_CH0 ),A			;		  :13(221)	データ書き込み[8](SOUND)
;
	DEC		HL							;		  : 6(227)
	LD		A,H							;  3(  3) : 1(228)
	OR		L							;  4(  7)
	JP		NZ,HIDDEN_FRAME_LOOP		; 10( 17)			17clk はみ出るが、どうせ書き込みウェイト100以上かかるので問題ない
;
; 最後の1ライン。データの最後かどうかのチェックの消費clkが大きいので個別処理に。
; (XXXXX HIDEN_FRAME_LOOP を 1回少なくして、最後のループではV-RAM書き込みの前にカウンタチェック)
;
	IN		A,(EMM_DATA)				; 12( 29)			データ読み取り[8](SOUND)
	LD		SP, VRAM + 1010				; 10( 39)			VRAM転送先。ダミーなので画面外に。8バイト書き込むので +1008以上であればOK
	DEC		IX							; 10( 49)
	LD		A,IXL						;  8( 57)
	OR		IXH							;  8( 65)
	JP		Z,RE_MUGEN_LOOP				; 10( 75)			0 の時は終わったらデータ先頭へ。
;
	PUSH	DE							;  5( 80) : 6(171)	データ書き込み[7,6]	5クロック消費して H_BLANKまで 165-80 clk 待たされる
	PUSH	DE							;		  :11(182)	データ書き込み[5,4]
	EXX									;		  : 4(186)	(表)	ダミーだけどメインループに戻る際に表に戻す必要がある。
	PUSH	DE							;		  :11(197)	データ書き込み[3,2]
	PUSH	DE							;		  :11(208)	データ書き込み[1,0]
	LD		( IO8253_CH0 ),A			;		  :13(221)	データ書き込み[8](SOUND)
;
	JP		MAIN_LOOP					;  3(  3) : 7(228)	画面先頭に。3clk はみ出るが問題ない。
;
RE_MUGEN_LOOP:
	PUSH	DE							;  5( 64) : 6(171)	データ書き込み[7,6]	5クロック消費して H_BLANKまで待たされる
	PUSH	HL							;		  :11(182)	データ書き込み[5,4]
	EXX									;		  : 4(186)	(表)	ダミーだけどメインループに戻る際に表に戻す必要がある。
	PUSH	DE							;		  :11(197)	データ書き込み[3,2]
	PUSH	HL							;		  :11(208)	データ書き込み[1,0]
	LD		( IO8253_CH0 ),A			;		  :13(221)	データ書き込み[8](SOUND)
	JP		MUGEN_LOOP					; 10(  3) : 7(228)	無限に動画をループ。3clk 遅れるが問題ない。先頭に戻る＝連続性はない、ので。
;
EXIT:
	LD		SP,0
	JP		$004A						; モニタに戻る(Inial Start)
;
; 1画面 262 ラスタで、1画面=2000byte書くのに 2000 / 8 = 250 ラスタかかるので、
; 262 - 250 = 12 ラスタが音声のみの処理となる。ただし、メインループに戻る時の
; オーバーヘッドがあり、最後の1回は例外とするので、ループ回数としては 12 - 1 = 11
; となる。
; さらに、fps が 60未満の場合、画面更新しないで音声のみのループが 262 * (表示しないフレーム数)
; あるので、 以下のような式になる。
;
SOUND_ONLY_LINE_TABLE:
	DW	( LINES_PER_FRAME - LINES_PER_SCREEN - 1 ) + ( LINES_PER_FRAME *  0 )	;  0=60fps	11
	DW	( LINES_PER_FRAME - LINES_PER_SCREEN - 1 ) + ( LINES_PER_FRAME *  1 )	;  1=30fps  11 + 262 = 273
	DW	( LINES_PER_FRAME - LINES_PER_SCREEN - 1 ) + ( LINES_PER_FRAME *  2 )	;  2=20fps
	DW	( LINES_PER_FRAME - LINES_PER_SCREEN - 1 ) + ( LINES_PER_FRAME *  3 )	;  3=15fps
	DW	( LINES_PER_FRAME - LINES_PER_SCREEN - 1 ) + ( LINES_PER_FRAME *  4 )	;  4=12fps
	DW	( LINES_PER_FRAME - LINES_PER_SCREEN - 1 ) + ( LINES_PER_FRAME *  5 )	;  5=10fps
	DW	( LINES_PER_FRAME - LINES_PER_SCREEN - 1 ) + ( LINES_PER_FRAME *  9 )	;  6=06fps
	DW	( LINES_PER_FRAME - LINES_PER_SCREEN - 1 ) + ( LINES_PER_FRAME * 11 )	;  7=05fps
	DW	( LINES_PER_FRAME - LINES_PER_SCREEN - 1 ) + ( LINES_PER_FRAME * 14 )	;  8=04fps
	DW	( LINES_PER_FRAME - LINES_PER_SCREEN - 1 ) + ( LINES_PER_FRAME * 19 )	;  9=03fps
	DW	( LINES_PER_FRAME - LINES_PER_SCREEN - 1 ) + ( LINES_PER_FRAME * 29 )	; 10=02fps
	DW	( LINES_PER_FRAME - LINES_PER_SCREEN - 1 ) + ( LINES_PER_FRAME * 59 )	; 11=01fps
	DW	0																		; 12=00fps 別途上書きされる(音声データ数で上書き)
	DW	( LINES_PER_FRAME - LINES_PER_SCREEN - 1 ) + ( LINES_PER_FRAME *  0 )	; 13=50fps	61
	DW	( LINES_PER_FRAME - LINES_PER_SCREEN - 1 ) + ( LINES_PER_FRAME *  1 )	; 14=25fps	61 + 312
	DW	( LINES_PER_FRAME - LINES_PER_SCREEN - 1 ) + ( LINES_PER_FRAME *  2 )	; 15=10fps
	DW	( LINES_PER_FRAME - LINES_PER_SCREEN - 1 ) + ( LINES_PER_FRAME *  3 )	; 16=05fps
	DW	( LINES_PER_FRAME - LINES_PER_SCREEN - 1 ) + ( LINES_PER_FRAME *  4 )	; 17=02fps
	DW	( LINES_PER_FRAME - LINES_PER_SCREEN - 1 ) + ( LINES_PER_FRAME *  5 )	; 18=01fps
;
	END
